/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.BaseEcStreamNameListener;
import com.ibm.hwmca.base.updates.BaseMcfKeywordListener;
import com.ibm.hwmca.base.updates.BaseUpdateStyle;
import com.ibm.hwmca.base.updates.BaseUpdater;
import com.ibm.hwmca.base.updates.ECFilter;
import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.EcStreamNameListener;
import com.ibm.hwmca.base.updates.EcStreamNameListenerManager;
import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.base.updates.McfKeywordListener;
import com.ibm.hwmca.base.updates.McfKeywordListenerManager;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateStyle;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BaseUpdatesOwner
implements UpdatesOwner,
MCLErrorIds {
    private static final String TRACE_MASKT = "XMCLOWNT";
    private static final String TRACE_MASKF = "XMCLOWNF";
    private static final String TRACE_MASKD = "XMCLOWND";
    protected static final String EC_CODE_FILES = "ecdbasetower";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");
    protected List updateableComponents = null;

    public BaseUpdatesOwner() {
        Trace.trace(TRACE_MASKT, "-> BaseUpdatesOwner()");
        UpdatesErrorIds lm = McfKeywordListenerManager.getMcfKeywordListenerManager();
        UpdatesErrorIds l = BaseMcfKeywordListener.getBaseMcfKeywordListener();
        ((McfKeywordListenerManager)lm).addListener((McfKeywordListener)((Object)l));
        lm = EcStreamNameListenerManager.getEcStreamNameListenerManager();
        l = BaseEcStreamNameListener.getBaseEcStreamNameListener();
        ((EcStreamNameListenerManager)lm).addListener((EcStreamNameListener)((Object)l));
        Trace.trace(TRACE_MASKT, "<- BaseUpdatesOwner()");
    }

    protected List findUpdateableComponents(String path) {
        Trace.trace(TRACE_MASKT, "-> BaseUpdatesOwner.findUpdateableComponents()");
        ArrayList<ECStream> components = new ArrayList<ECStream>();
        try {
            Trace.trace(TRACE_MASKF, "   BaseUpdatesOwner.findUpdateableComponents() - path is [" + path + "]");
            File ecCodeFile = new File(path);
            String[] files = ecCodeFile.list(new ECFilter("ecd"));
            for (int i = 0; i < files.length; ++i) {
                String fileName = path + files[i];
                Trace.trace(TRACE_MASKF, "   BaseUpdatesOwner.findUpdateableComponents() - the file " + fileName + " represents an " + "updateable compenent");
                try {
                    ECStream nextECstream = new ECStream(this, fileName);
                    components.add(nextECstream);
                    continue;
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKF, "   BaseUpdatesOwner.findUpdateableComponents() - could not construct an EC stream from file " + fileName + ", we will ignore " + "this file.");
                }
            }
        }
        catch (RuntimeException e) {
            String msg = "path argument is not correct";
            HException he = new HException(msg, e);
            this.logError(msg, (short)-4096, he);
        }
        Trace.trace(TRACE_MASKT, "<- BaseUpdatesOwner.findUpdateableComponents()");
        return components;
    }

    public List getUpdateableComponents() {
        Trace.trace(TRACE_MASKT, "-> BaseUpdatesOwner.getUpdateableComponents()");
        try {
            String ecCodePath = BaseFileControl.getFilePath(EC_CODE_FILES);
            if (null == this.updateableComponents) {
                this.updateableComponents = this.findUpdateableComponents(ecCodePath);
            }
        }
        catch (HException hexc) {
            this.updateableComponents = new ArrayList();
            this.logError("Unable to find where ECC or ECD files go", (short)-4096, hexc);
        }
        Trace.trace(TRACE_MASKT, "-> BaseUpdatesOwner.getUpdateableComponents() returns " + this.updateableComponents.size() + " components.");
        return this.updateableComponents;
    }

    public Updater getUpdaterInstance() {
        return new BaseUpdater(this);
    }

    public UpdateStyle getUpdateStyle() {
        return new BaseUpdateStyle();
    }

    private void logError(String errorString, short errorId, HException hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        Trace.trace(TRACE_MASKD, "<- logError()");
    }
}

